// AcMapFlatOrclApiTestLoadQueryDlg.cpp : implementation file
//
///////////////////////////////////////////////////////////////////////////////
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Hugues Wisniewski, June 2001
//
// DESCRIPTION:
// 	Implementation of class AcMapFlatOrclApiTestLoadQueryDlg

#include "stdafx.h"
#include "AcMapFlatOrclApiTestLoadQueryDlg.h"
#include "AdMapOracleConnection.h"
#include <string>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AcMapFlatOrclApiTestLoadQueryDlg dialog


//******************************************************************************************
AcMapFlatOrclApiTestLoadQueryDlg::AcMapFlatOrclApiTestLoadQueryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(AcMapFlatOrclApiTestLoadQueryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(AcMapFlatOrclApiTestLoadQueryDlg)
	m_strQueryName = _T("");
	//}}AFX_DATA_INIT
}


//******************************************************************************************
void AcMapFlatOrclApiTestLoadQueryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(AcMapFlatOrclApiTestLoadQueryDlg)
	DDX_Control(pDX, IDC_LIST_QUERY_NAMES, m_listQueryNames);
	DDX_LBString(pDX, IDC_LIST_QUERY_NAMES, m_strQueryName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(AcMapFlatOrclApiTestLoadQueryDlg, CDialog)
	//{{AFX_MSG_MAP(AcMapFlatOrclApiTestLoadQueryDlg)
	ON_LBN_DBLCLK(IDC_LIST_QUERY_NAMES, OnDblclkListQueryNames)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// AcMapFlatOrclApiTestLoadQueryDlg message handlers

//******************************************************************************************
BOOL AcMapFlatOrclApiTestLoadQueryDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	std::string strQuery=
		"select NAME "
		"from ADMPIMPORTSETTINGS ";

	try
	{
		ODynaset dynaset(AcMapOSEGetConnection()->Database(), strQuery.c_str());
		if (!dynaset.IsOpen())
		{
			AfxMessageBox("Could not read the table ADMPIMPORTSETTINGS");
			EndDialog(IDCANCEL);
			return false;
		}

		for(dynaset.MoveFirst(); FALSE == dynaset.IsEOF(); dynaset.MoveNext())
		{
			oresult ores;
			char szName[1000];

			ores = dynaset.GetFieldValue(
				"NAME", 
				szName, 
				sizeof(szName));
			if (OFAILURE==ores)
			{
				AfxMessageBox("Could not read the table ADMPIMPORTSETTINGS");
				EndDialog(IDCANCEL);
				return false;
			}

			m_listQueryNames.AddString(szName);
		}
	}
	catch(OException E)
	{
		AfxMessageBox("Could not read the table ADMPIMPORTSETTINGS");
		EndDialog(IDCANCEL);
		return false;
	}

	if (0==m_listQueryNames.GetCount())
	{
		AfxMessageBox("There is no saved query in this schema");
		EndDialog(IDCANCEL);
		return false;
	}

	m_strQueryName="";
	UpdateData(FALSE);

	return TRUE;
}

//******************************************************************************************
void AcMapFlatOrclApiTestLoadQueryDlg::OnDblclkListQueryNames() 
{
	UpdateData(TRUE);
	EndDialog(IDOK);
}

//******************************************************************************************
void AcMapFlatOrclApiTestLoadQueryDlg::OnOK() 
{
	UpdateData(TRUE);
	CDialog::OnOK();
}
